/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class SolarCookerBlockEntityRenderer
implements class_827<SolarCookerBlockEntity> {
    public static final class_2960 TEXTURE = Constants.id("textures/entity/solar_cooker.png");
    public static final class_2960 TEXTURE_REFLECTOR = Constants.id("textures/entity/solar_cooker_reflector.png");
    private static final class_5607 innerCube = SolarCookerBlockEntityRenderer.createInnerLayerDefinition();
    private static final class_5607 reflectorLeftCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(true);
    private static final class_5607 reflectorRightCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(false);
    private final class_630 lid;
    private final class_630 bottom;
    private final class_630 inner;
    private final class_630 lock;
    private final class_630 reflectorLeft;
    private final class_630 reflectorRight;

    private static class_5607 createInnerLayerDefinition() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        partdefinition.method_32117("inner", class_5606.method_32108().method_32101(0, 43).method_32097(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    private static class_5607 createReflectorLayerDefinition(boolean left) {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        float offset = left ? 0.0f : 13.998f;
        float rotation = left ? 0.0f : (float)Math.PI;
        partdefinition.method_32117("reflector", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 6.999f, 1.0f, 13.998f), class_5603.method_32091((float)(1.001f + offset), (float)10.001f, (float)(1.001f + offset), (float)0.0f, (float)rotation, (float)0.0f));
        return class_5607.method_32110((class_5609)meshdefinition, (int)42, (int)15);
    }

    public SolarCookerBlockEntityRenderer(class_5614.class_5615 rendererProvider) {
        class_630 modelpart = rendererProvider.method_32140(class_5602.field_27689);
        this.bottom = modelpart.method_32086("bottom");
        this.lid = modelpart.method_32086("lid");
        this.lock = modelpart.method_32086("lock");
        this.inner = innerCube.method_32109().method_32086("inner");
        this.reflectorLeft = reflectorLeftCube.method_32109().method_32086("reflector");
        this.reflectorRight = reflectorRightCube.method_32109().method_32086("reflector");
    }

    public void render(SolarCookerBlockEntity blockEntity, float partialTicks, @Nonnull class_4587 matrixStackIn, @Nonnull class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_1937 world = blockEntity.method_10997();
        boolean isInWorld = world != null;
        class_2680 blockstate = isInWorld ? blockEntity.method_11010() : (class_2680)Constants.SOLAR_COOKER_BLOCK.get().method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2248 block = blockstate.method_26204();
        if (block instanceof AbstractSolarCookerBlock) {
            matrixStackIn.method_22903();
            float f = ((class_2350)blockstate.method_11654((class_2769)AbstractSolarCookerBlock.FACING)).method_10144();
            matrixStackIn.method_22904(0.5, 0.5, 0.5);
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(-f));
            matrixStackIn.method_22904(-0.5, -0.5, -0.5);
            class_4588 vertexConsumer = bufferIn.getBuffer(class_1921.method_23580((class_2960)TEXTURE));
            float lidAngle = blockEntity.method_11274(partialTicks);
            this.renderModels(matrixStackIn, vertexConsumer, lidAngle, combinedLightIn, combinedOverlayIn);
            if (lidAngle > 0.0f) {
                class_1799 stack;
                if (blockEntity.hasLeftReflector() || blockEntity.hasRightReflector()) {
                    vertexConsumer = bufferIn.getBuffer(class_1921.method_23580((class_2960)TEXTURE_REFLECTOR));
                    this.renderReflectors(matrixStackIn, vertexConsumer, blockEntity.hasLeftReflector(), blockEntity.hasRightReflector(), lidAngle, combinedLightIn, combinedOverlayIn);
                }
                if (isInWorld && !(stack = blockEntity.method_5438(0)).method_7960()) {
                    matrixStackIn.method_22903();
                    matrixStackIn.method_22904(0.5, 0.4, 0.5);
                    class_310.method_1551().method_1480().method_23178(stack, class_811.field_4318, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, world, 0);
                    matrixStackIn.method_22909();
                }
            }
            matrixStackIn.method_22909();
        }
    }

    private void renderModels(class_4587 matrixStackIn, class_4588 bufferIn, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        this.lock.field_3654 = this.lid.field_3654 = -(lidAngle * 1.5707964f);
        this.lid.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.lock.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.bottom.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.inner.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderReflectors(class_4587 matrixStackIn, class_4588 bufferIn, boolean hasLeftReflector, boolean hasRightReflector, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        float angle = lidAngle * 1.7453294f;
        if (hasLeftReflector) {
            this.reflectorLeft.field_3674 = angle;
            this.reflectorLeft.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        if (hasRightReflector) {
            this.reflectorRight.field_3674 = -angle;
            this.reflectorRight.method_22698(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }
}

